<?php

namespace App\Filament\Resources\BillofladingResource\Pages;

use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Resources\BillofladingResource;
use App\Models\Port;

class CreateBilloflading extends CreateRecord
{
    protected static string $resource = BillofladingResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $pod = Port::where('id', $data['port_of_discharge'])->with('office')->first();
        $delivery_agent = $pod?$pod->office:$pod->office->id;
        $data['delivery_agent_id'] = $delivery_agent;

        $data['entry_by'] = auth()->id();
        $data['organization_id'] = auth()->user()->organization_id;
        // dd($data);

        return $data;
    }
}
