<?php

namespace App\Filament\Resources\BLResource\Pages;

use Filament\Actions;
use App\Models\Office;
use App\Traits\HasBLUser;
use Filament\Actions\Action;
use App\Filament\Resources\BLResource;
use Illuminate\Database\Eloquent\Model;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;

class EditBL extends EditRecord
{
    use HasBLUser;
    
    protected static string $resource = BLResource::class;
    protected static $recordBeforeSaved = NULL;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('print_ridersheet')
                ->label('Rider Sheet')
                ->url(fn (?Model $record): string => route('shipping.bl.ridersheet', $record->bl))
                ->icon('heroicon-o-newspaper')
                // ->hidden(fn (?Model $record): string => $record->hasRiderSheet())
                ->visible($this->record->hasRiderSheet())
                ->color('lime')
                ->openUrlInNewTab(),

            Action::make('pdf')
                ->label('PDF')
                ->url(fn (?Model $record): string => route('shipping.bl.pdf', $record->bl))
                ->icon('heroicon-o-document')
                // ->color('success')
                ->openUrlInNewTab(),
            
            Action::make('print')
                ->url(fn (?Model $record): string => route('shipping.bl.print', $record->bl))
                ->icon('heroicon-o-printer')
                ->openUrlInNewTab(),
                
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        self::$recordBeforeSaved = $this->getRecord()->getOriginal();
        
        $office = Office::where('city_id', $data['final_destination_city_id'])->first();
        $data['delivery_agent_id'] = $office?$office->id:null;

        // set issue_date same as eta if empty
        // $data['issue_date'] = $data['issue_date']?:$data['eta'];
        // dd($data['eta'], $data['shipped_on_board'], $data['issue_date']);

        $data['last_updated_by_user_id'] = auth()->id();
    
        return $data;
    }
    protected function afterSave(): void
    {
        // dd($this->model($this->getRecord())->getUpdatedActivity()->getData());
        // dd($this->checkBL($this->getRecord())->getAllEmails());
        $emails = $this->checkBL($this->getRecord())->getAllEmails();

        $changes = $this->getRecord()->getChanges();
        // dd(self::$recordBeforeSaved, $this->getRecord()->getChanges());
        $ignoredKeys = ['updated_at', 'created_at'];

        foreach ($changes as $key => $value) {
            if (!in_array($key, $ignoredKeys) && self::$recordBeforeSaved[$key] != $value) {
                // dd('Key: '. $key, 'old value: '. self::$recordBeforeSaved[$key], 'new value: '. $value, !in_array($key, $ignoredKeys), self::$recordBeforeSaved[$key] != $value, $changes);

                // need to work
                // email should be individual, need to send single mail to single user
                // Ship vector missing
                // mail template should be dynamic (created, updated, deleted etc.)
                // Mail::to($emails)->send(new BLCreated($this->getRecord()));
                break;
            }
        }
    }

    public function getTitle(): string|\Illuminate\Contracts\Support\Htmlable
    {
        return 'Edit ' . $this->getRecordTitle() . ' #' . $this->getRecord()->bl_no;
    }
    
    protected function getSavedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->title('Bill Of Lading updated')
            ->body('The Bill Of Lading has been saved successfully.');
    }
}
