<?php

namespace App\Filament\Resources\BLResource\Pages;

use Filament\Actions;
use App\Models\Office;
use App\Traits\HasBLNumber;
use App\Models\Organization;
use Illuminate\Support\Facades\Auth;
use App\Filament\Resources\BLResource;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;

class CreateBL extends CreateRecord
{
    use HasBLNumber;
    
    protected static string $resource = BLResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['bl_no'] = $this->generate($data['place_of_loading_id'], $data['port_of_discharge_id']);
        // $office = Office::where('city_id', $data['final_destination_city_id'])->first();
        // // dd($data['final_destination_city_id'], $office);
        // $data['delivery_agent_id'] = $office?$office->id:null;
        $data['delivery_agent_id'] = $this->getDeliveryAgentOffice($data['final_destination_city_id']);

        // $data['issue_date'] = $data['issue_date']?:$data['eta'];

        // dd(OfficeStaff::select('office_id')->where('office_user_id', 2)->first());
        // $org = Organization::find(Auth::user()->organization_id);
        // $data['office_id'] = $org?$org->office_id:null;
        $data['office_id'] = $this->getOfficeID();
        // dd($data['office_id']);

        $data['posted_user_type'] = 1; //1=customer, 2=office, 3=other
        $data['posted_by_user_id'] = auth()->id();

        $data['customer_created'] = true;
        $data['organization_id'] = auth()->user()->organization_id;
        // dd($data);

        return $data;
    }

    protected function getOfficeID() : int|null {
        $org = Organization::find(Auth::user()->organization_id);
        $office_id = $org?->office_id;

        return $office_id;
    }

    protected function getDeliveryAgentOffice($final_destination_city_id) : int|null {
        $office = Office::where('city_id', $final_destination_city_id)->first();
        return $office?->id;
    }
    
    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->title('Bill Of Lading Created')
            ->body('A New Bill Of Lading has been added successfully.');
    }
}
