<?php

namespace App\Filament\Office\Resources;

use App\Filament\Office\Resources\SlotBookingResource\Pages;
use App\Filament\Office\Resources\SlotBookingResource\RelationManagers;
use App\Models\SlotBooking;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class SlotBookingResource extends Resource
{
    protected static ?string $model = SlotBooking::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';
    protected static ?string $slug = 'shipping/slot-bookings';
    protected static ?string $navigationParentItem = 'Service Routes';
    protected static ?string $navigationGroup = 'Shipping';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('schedule_id')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('con_size')
                    ->required()
                    ->maxLength(20)
                    ->default('20_hc'),
                Forms\Components\TextInput::make('requested_tues')
                    ->numeric()
                    ->default(1),
                Forms\Components\TextInput::make('booked_tues')
                    ->numeric()
                    ->default(1),
                Forms\Components\TextInput::make('loaded_tues')
                    ->numeric()
                    ->default(1),
                Forms\Components\TextInput::make('cost_per_tue')
                    ->numeric()
                    ->default(0.00),
                Forms\Components\TextInput::make('approx_selling_price')
                    ->numeric()
                    ->default(0.00),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('schedule_id')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('con_size')
                    ->searchable(),
                Tables\Columns\TextColumn::make('requested_tues')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('booked_tues')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('loaded_tues')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('cost_per_tue')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('approx_selling_price')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ManageSlotBookings::route('/'),
        ];
    }
}
