<?php

namespace App\Filament\Office\Resources\OrganizationResource\Pages;

use Filament\Actions;
use App\Models\OfficeStaff;
use Illuminate\Support\Facades\Auth;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Office\Resources\OrganizationResource;

class CreateOrganization extends CreateRecord
{
    protected static string $resource = OrganizationResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $office_stuff = OfficeStaff::select('office_id')->where('office_user_id', Auth::id())->first();
        $data['office_id'] = $office_stuff?$office_stuff->office_id:null;

        $data['added_by_user_id'] = Auth::id();
        // $data['updated_by_user_id'] = Auth::id();
        // $data['deleted_by_user_id'] = Auth::id();
        // dd($data['office_id']);

        return $data;
    }
    
    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->title('Organization Created')
            ->body('A New Organization has been added successfully.');
    }
}
