<?php

namespace App\Filament\Office\Resources;

use App\Models\BL;
use Filament\Forms;
use Filament\Tables;
use Filament\Forms\Form;
use App\Models\Container;
use Filament\Tables\Table;
use Illuminate\Support\Arr;
use App\Enums\ContainerSizes;
use App\Enums\ContainerTypes;
use App\Enums\ContainerStatuses;
use Filament\Resources\Resource;
use Filament\Tables\Filters\Filter;
use App\Enums\ContainerPropertyTypes;
use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Enums\FiltersLayout;
use Filament\Tables\Columns\ToggleColumn;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Office\Resources\ContainerResource\Pages;
use App\Filament\Resources\ContainerResource\RelationManagers;

class ContainerResource extends Resource
{
    protected static ?string $model = Container::class;

    protected static ?string $slug = 'shipping/containers';

    protected static ?string $navigationGroup = 'Shipping';
    protected static ?string $navigationIcon = 'heroicon-o-view-columns';
    
    public static function shouldRegisterNavigation(): bool
    {
        return auth()->user()?auth()->user()->can('viewAny', BL::class):false;
    }

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
            // 'container_no'
            // 'size'
            // 'type'
            // 'status'
            // 'property_type'
            // 'free_days'
            // 'available'
            // 'last_updated_by'
            // 'added_by'
            // 'deleted_by'

                Forms\Components\TextInput::make('container_no')
                    ->required()
                    ->maxLength(255),
                Forms\Components\Select::make('size')
                    ->options(ContainerSizes::class)
                    ->default('20_hc')
                    ->required()
                    ->searchable(),
                Forms\Components\Select::make('type')
                    ->options(ContainerTypes::class)
                    ->required()
                    ->searchable(),
                Forms\Components\Select::make('status')
                    ->options(ContainerStatuses::class)
                    ->default('empty')
                    ->required()
                    ->searchable(),
                Forms\Components\Select::make('property_type')
                    ->options(ContainerPropertyTypes::class)
                    ->searchable(),
                Forms\Components\TextInput::make('free_days')
                    ->datalist([15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 120])
                    ->numeric(),
                Forms\Components\Toggle::make('available')
                    ->required(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                TextColumn::make('container_no')
                        ->description(function(Container $record):string {
                            $desc = '';
                            if (!empty($record->type)) {
                                $desc .= $record->type->getLabel();
                            }
                            
                            if ($record->property_type != null) {
                                if (!empty($record->type)) {
                                    $desc .= ' ⋅ ';
                                }
                                $desc .= $record->property_type->getLabel();
                            }
                            
                            if ($record->free_days != null) {
                                if ($record->property_type != null) {
                                    $desc .= ' ⋅ ';
                                }
                                if (!empty($record->type) && $record->property_type == null) {
                                    $desc .= ' ⋅ ';
                                }
                                $desc .= ucwords($record->free_days . ' Free Days');
                            }
                            return $desc;
                        })
                    ->sortable()
                    ->searchable(),
                TextColumn::make('size')
                    ->sortable()
                    ->searchable(),
                // TextColumn::make('type')
                //     ->searchable(),
                TextColumn::make('status')
                    // ->formatStateUsing(fn($state) => strtoupper(str_replace('_', ' ', $state)))
                    // ->formatStateUsing(fn($state) => dd($state->value))
                    ->badge()
                    // ->color(fn (string $state): string => Arr::random(['gray', 'warning', 'success', 'danger', 'agent']))
                    // ->color(fn (ContainerStatuses $state): string => match($state->value) {
                    //     'on_hire' => 'secondary',
                    //     'off_hire' => 'gray',
                    //     'sold' => 'agent',
                    //     'purchased' => 'success',
                    //     'lost' => 'danger',
                    //     'damaged' => 'warning'
                    // })
                    ->sortable()
                    ->searchable(),
                // TextColumn::make('property_type')
                //     ->searchable(),
                // TextColumn::make('free_days')
                //     ->searchable(),
                ToggleColumn::make('available'),
                TextColumn::make('last_updated_by')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->searchable(),
                TextColumn::make('added_by')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->searchable(),
                TextColumn::make('deleted_by')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->searchable(),

            // 'container_no'
            // 'size'
            // 'type'
            // 'status'
            // 'property_type'
            // 'free_days'
            // 'available'
            // 'last_updated_by'
            // 'added_by'
            // 'deleted_by'
            ])
            ->filters([
                Tables\Filters\SelectFilter::make('type')
                    ->multiple()
                    ->options(ContainerTypes::class),
                Tables\Filters\SelectFilter::make('status')
                    ->multiple()
                    ->options(ContainerStatuses::class),
                Tables\Filters\SelectFilter::make('property_type')
                    ->options(ContainerPropertyTypes::class),
                Tables\Filters\SelectFilter::make('available')
                    ->options([
                        '1' => 'Available',
                        '0' => 'Not Available',
                    ]),
                Tables\Filters\TrashedFilter::make(),
                // Filter::make('available')
                //     ->query(fn (Builder $query): Builder => $query->where('available', true))
                //     ->toggle(),
            ], layout: FiltersLayout::AboveContent)
            ->filtersFormColumns(5)
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                    Tables\Actions\ForceDeleteBulkAction::make(),
                    Tables\Actions\RestoreBulkAction::make(),
                ]),
            ])
            ->emptyStateActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->striped();
    }
    
    public static function getRelations(): array
    {
        return [
            // RelationManagers\HistoryRelationManager::class,
        ];
    }
    
    public static function getPages(): array
    {
        return [
            'index' => Pages\ListContainers::route('/'),
            'create' => Pages\CreateContainer::route('/create'),
            'edit' => Pages\EditContainer::route('/{record}/edit'),
        ];
    }    
    
    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->withoutGlobalScopes([
                SoftDeletingScope::class,
            ]);
    }
}
