<?php

namespace App\Filament\Office\Resources\BLResource\Pages;

use App\Traits\HasBLUser;
use Filament\Actions;
use App\Models\Office;
use App\Mail\BLCreated;
use App\Classes\TzDateTime;
use Filament\Actions\Action;
use Illuminate\Support\Facades\Mail;
use Illuminate\Database\Eloquent\Model;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Office\Resources\BLResource;

class EditBL extends EditRecord
{
    use HasBLUser;
    protected static string $resource = BLResource::class;
    protected static $recordBeforeSaved = NULL;

    protected function getHeaderActions(): array
    {
        return [
            Action::make('activities')
                ->url(fn ($record) => BLResource::getUrl('activities', ['record' => $record]))
                ->icon('heroicon-o-rectangle-stack')
                ->color('slate'),
            Action::make('print_ridersheet')
                ->label('Rider Sheet')
                ->url(fn (?Model $record): string => route('shipping.bl.ridersheet', $record->bl))
                ->icon('heroicon-o-newspaper')
                // ->hidden(fn (?Model $record): string => $record->hasRiderSheet())
                ->visible($this->record->hasRiderSheet())
                ->color('lime')
                ->openUrlInNewTab(),

            Action::make('print_certificate')
                ->label('Certificate')
                ->url(fn (?Model $record): string => route('shipping.bl.certificate', $record->bl))
                ->icon('heroicon-o-identification')
                ->hidden(fn (?Model $record): string => $record->bl_certificates->count() < 1)
                ->color('lime')
                ->openUrlInNewTab(),
                
            Action::make('pdf')
                ->label('PDF')
                ->url(fn (?Model $record): string => route('shipping.bl.pdf', $record->bl))
                ->icon('heroicon-o-document')
                // ->color('success')
                ->openUrlInNewTab(),
            
            Action::make('print')
                ->url(fn (?Model $record): string => route('shipping.bl.print', $record->bl))
                ->icon('heroicon-o-printer')
                ->openUrlInNewTab(),
            Actions\DeleteAction::make(),
            Actions\ForceDeleteAction::make(),
            Actions\RestoreAction::make(),
        ];
    }

    protected function mutateFormDataBeforeSave(array $data): array
    {
        self::$recordBeforeSaved = $this->getRecord()->getOriginal();

        // set delivery agent based on selected country and city
        if (isset($data['final_destination_city_id'])) {
            $office = Office::where('city_id', $data['final_destination_city_id'])->first();
            $data['delivery_agent_id'] = $office?$office->id:null;
            // dd($data['delivery_agent_id']);
        }

        // set shipped_on_board and issue_date same as eta if empty

        // if ($data['is_final']) {
        //     if (isset($data['shipped_on_board'])) {
        //         $data['shipped_on_board'] = $data['shipped_on_board']?:$data['eta'];
        //     }
            
        //     if (isset($data['issue_date'])) {
        //         $data['issue_date'] = $data['issue_date']?:$data['eta'];
        //     }
        // }
        
        // dd($data['eta'], $data['shipped_on_board'], $data['issue_date']);

        // set finalize by office user
        $data['final_by_user_id'] = null;
        if ($this->getRecord()->is_final == 0 && $data['is_final'] == 1) {
            $data['final_by_user_id'] = auth()->id();
        }
        
        // set last updated by office user
        $data['last_updated_by_user_id'] = auth()->id();
    
        return $data;
    }
    
    protected function afterSave(): void
    {
        // dd($this->model($this->getRecord())->getUpdatedActivity()->getData());
        // dd($this->checkBL($this->getRecord())->getAllEmails());
        $emails = $this->checkBL($this->getRecord())->getAllEmails();

        $changes = $this->getRecord()->getChanges();
        // dd(self::$recordBeforeSaved, $this->getRecord()->getChanges());
        $ignoredKeys = ['updated_at', 'created_at'];

        foreach ($changes as $key => $value) {
            if (!in_array($key, $ignoredKeys) && self::$recordBeforeSaved[$key] != $value) {
                // dd('Key: '. $key, 'old value: '. self::$recordBeforeSaved[$key], 'new value: '. $value, !in_array($key, $ignoredKeys), self::$recordBeforeSaved[$key] != $value, $changes);

                // need to work
                // email should be individual, need to send single mail to single user
                // Ship vector missing
                // mail template should be dynamic (created, updated, deleted etc.)
                // Mail::to($emails)->send(new BLCreated($this->getRecord()));
                break;
            }
        }
    }
    
    protected function getSavedNotification(): ?Notification
    {
        // return (new BLCreated(BL::withoutGlobalScopes()->find(1)))->render();
        return Notification::make()
            ->success()
            ->title('Bill Of Lading updated')
            ->body('The Bill Of Lading has been saved successfully.');
    }

    public function getTitle(): string|\Illuminate\Contracts\Support\Htmlable
    {
        return 'Edit ' . $this->getRecordTitle() . ' #' . $this->getRecord()->bl_no;
    }

    public function getSubheading(): string|\Illuminate\Contracts\Support\Htmlable|null
    {
        $activity = $this->getRecord()->activities()->where('event', 'created')->orWhere('event', 'updated')->with('causer')->latest()->first();

        $user_type = ' (Customer)';
        if (!empty($activity->causer_type) && $activity->causer_type == 'App\Models\OfficeUser') {
            $user_type = ' (Office)';
        }
        
        $last_updated_at = 'Last updated at ' . $this->getRecord()->updated_at->timezone(TzDateTime::getOfficeTimeZone()->zoneName)->format('d-M-Y h:i A');
        $last_updated_by = !empty($activity->causer)?(' by ' . $activity->causer?->name . $user_type):null;

        return $last_updated_at . $last_updated_by;
    }
}
