<?php

namespace App\Filament\Office\Resources\BLResource\Pages;

use App\Traits\HasBLNumber;
use Filament\Actions;
use App\Models\Office;
use App\Models\OfficeStaff;
use App\Models\Organization;
use Illuminate\Support\Facades\Auth;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Office\Resources\BLResource;

class CreateBL extends CreateRecord
{

    use HasBLNumber;

    protected static string $resource = BLResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // dd($data);
        // $bl_number = $this->generate($data['place_of_loading_id'], $data['port_of_discharge_id']);
        // // dd($this->updateLastNumber($bl_number, $data['place_of_loading_id'], $data['port_of_discharge_id']));
        // dd($bl_number);
        $data['bl_no'] = $this->generate($data['place_of_loading_id'], $data['port_of_discharge_id']);
        // $office = Office::where('city_id', $data['final_destination_city_id'])->first();
        // $data['delivery_agent_id'] = $office?$office->id:null;
        $data['delivery_agent_id'] = $this->getDeliveryAgentOffice($data['final_destination_city_id']);

        // if ($data['is_final']) {
        //     $data['shipped_on_board'] = $data['shipped_on_board']?:$data['eta'];
        //     $data['issue_date'] = $data['issue_date']?:$data['eta'];
        // }

        // dd(OfficeStaff::select('office_id')->where('office_user_id', 2)->first());
        // if (auth()->user()->is_customer()) {
        //     $org = Organization::find(Auth::user()->organization_id);
        //     $data['office_id'] = $org?$org->office_id:null;
        // } else  {
        //     $office_stuff = OfficeStaff::select('office_id')->where('office_user_id', Auth::id())->first();
        //     $data['office_id'] = $office_stuff?$office_stuff->office_id:null;
        // }

        $data['office_id'] = $this->getOfficeID();

        $data['posted_user_type'] = 2; //1=customer, 2=office, 3=other
        $data['posted_by_user_id'] = auth()->id();
        // dd($data);

        return $data;
    }

    protected function getOfficeID() : int|null {
        if (auth()->user()->is_customer()) {
            $org = Organization::find(Auth::user()->organization_id);
            $office_id = $org?->office_id;
        } else  {
            $office_stuff = OfficeStaff::select('office_id')->where('office_user_id', Auth::id())->first();
            $office_id = $office_stuff?->office_id;
        }

        return $office_id;
    }

    protected function getDeliveryAgentOffice($final_destination_city_id) : int|null {
        $office = Office::where('city_id', $final_destination_city_id)->first();
        return $office?->id;
    }
    
    protected function getCreatedNotification(): ?Notification
    {
        return Notification::make()
            ->success()
            ->title('Bill Of Lading Created')
            ->body('A New Bill Of Lading has been added successfully.');
    }
}
