<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum OfficeTypes: string implements HasLabel, HasColor, HasIcon
{
    case BRANCH = 'branch';
    case AGENT = 'agent';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::BRANCH => 'Branch',
            self::AGENT => 'Agent',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::BRANCH => 'secondary',
            self::AGENT => 'agent',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::BRANCH => 'heroicon-o-building-office-2',
            self::AGENT => 'heroicon-o-building-office',
        };
    }
}