<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum ContainerStatuses: string implements HasLabel, HasColor, HasIcon
{
    case EMPTY = 'empty';
    case LADEN = 'laden';
    case DEMURRAGE = 'demurrage';
    case DETENTION = 'detention';
    case IN_REVIEW = 'in_review';
    case NOT_MANIFESTED = 'not_manifested';
    case OUT_OF_NETWORK = 'out_of_network';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::EMPTY => 'Empty',
            self::LADEN => 'Laden',
            self::DEMURRAGE => 'Demurrage',
            self::DETENTION => 'Detention',
            self::IN_REVIEW => 'In Review',
            self::NOT_MANIFESTED => 'Not Manifested',
            self::OUT_OF_NETWORK => 'Out Of Network',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::EMPTY => 'secondary',
            self::LADEN => 'gray',
            self::DEMURRAGE => 'agent',
            self::DETENTION => 'success',
            self::IN_REVIEW => 'danger',
            self::NOT_MANIFESTED => 'warning',
            self::OUT_OF_NETWORK => 'warning',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::EMPTY => 'heroicon-m-bolt',
            self::LADEN => 'heroicon-m-bolt-slash',
            self::DEMURRAGE => 'heroicon-m-forward',
            self::DETENTION => 'heroicon-m-check',
            self::IN_REVIEW => "heroicon-m-x-mark",
            self::NOT_MANIFESTED => "heroicon-m-lifebuoy",
            self::OUT_OF_NETWORK => "heroicon-m-lifebuoy",
        };
    }
}