<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum ContainerEvents: string implements HasLabel, HasColor, HasIcon
{
    case ON_HIRE = "on_hire";
    case OFF_HIRE = "off_hire";
    case SOLD = "sold";
    case PURCHASED = "purchased";
    case LOST = "lost";
    case DAMAGED = "damaged";

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::ON_HIRE => "On Hire",
            self::OFF_HIRE => "Off Hire",
            self::SOLD => "Sold",
            self::PURCHASED => "Purchased",
            self::LOST => "Lost",
            self::DAMAGED => "Damaged",
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::ON_HIRE => 'secondary',
            self::OFF_HIRE => 'gray',
            self::SOLD => 'agent',
            self::PURCHASED => 'success',
            self::LOST => 'danger',
            self::DAMAGED => 'warning'
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::ON_HIRE => 'heroicon-m-bolt',
            self::OFF_HIRE => 'heroicon-m-bolt-slash',
            self::SOLD => 'heroicon-m-forward',
            self::PURCHASED => 'heroicon-m-check',
            self::LOST => "heroicon-m-x-mark",
            self::DAMAGED => "heroicon-m-lifebuoy",
        };
    }
}