<?php

namespace App\Enums;

use Filament\Panel;
use Filament\Support\Colors\Color;

enum Colors: string
{
    case PRIMARY = 'primary';
    case SECONDARY = 'secondary';
    case INFO = 'info';
    case SUCCESS = 'success';
    case WARNING = 'warning';
    case DANGER = 'danger';
    case AGENT = 'agent';
    case GRAY = 'gray';
    case PINK = 'pink';
    case PURPLE = 'purple';
    case VIOLET = 'violet';
    case SKY = 'sky';
    case CYAN = 'cyan';
    case TEAL = 'teal';
    case GREEN = 'green';
    case LIME = 'lime';
    case YELLOW = 'yellow';
    case RED = 'red';
    case STONE = 'stone';
    case NEUTRAL = 'neutral';
    case ZINC = 'zinc';
    case SLATE = 'slate';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function forSelect(): array 
    {
        return array_combine(
            array_column(self::cases(), 'value'),
            array_column(self::cases(), 'name')
        );
    }
    
    public static function register(Panel $panel) : array {
        $primary = Color::Indigo;
        $secondary = Color::Fuchsia;
        if ($panel->getId() === 'app') {
            $primary = Color::Blue;
            $secondary = Color::Amber;
        }
        return [
            'agent' => Color::Amber,
            'secondary' => $secondary,
            // 'secondary' => Color::Fuchsia,
            'danger' => Color::Rose,
            'gray' => Color::Gray,
            'info' => Color::Blue,
            'primary' => $primary,
            // 'primary' => Color::Indigo,
            'success' => Color::Emerald,
            'warning' => Color::Orange,
            'pink' => Color::Pink,
            'purple' => Color::Purple,
            'violet' => Color::Violet,
            'sky' => Color::Sky,
            'cyan' => Color::Cyan,
            'teal' => Color::Teal,
            'green' => Color::Green,
            'lime' => Color::Lime,
            'yellow' => Color::Yellow,
            'red' => Color::Red,
            'stone' => Color::Stone,
            'neutral' => Color::Neutral,
            'zinc' => Color::Zinc,
            'slate' => Color::Slate,
        ];
    }
}