<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum CargoTypes: string implements HasLabel, HasColor, HasIcon
{
    case LFCL = 'lcl_fcl';
    case LLCL = 'lcl_lcl';
    case FLCL = 'fcl_lcl';
    case FFCL = 'fcl_fcl';
    case CYCFS = 'cy_cfs';
    case CYCY = 'cy_cy';
    case CFSCY = 'cfs_cy';
    case CFSCFS = 'cfs_cfs';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::LFCL => 'LCL/FCL',
            self::LLCL => 'LCL/LCL',
            self::FLCL => 'FCL/LCL',
            self::FFCL => 'FCL/FCL',
            self::CYCFS => 'CY/CFS',
            self::CYCY => 'CY/CY',
            self::CFSCY => 'CFS/CY',
            self::CFSCFS => 'CFS/CFS',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::LFCL => 'info',
            self::LLCL => 'agent',
            self::FLCL => 'violet',
            self::FFCL => 'success',
            self::CYCFS => 'info',
            self::CYCY => 'agent',
            self::CFSCY => 'violet',
            self::CFSCFS => 'success',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::LFCL => 'heroicon-o-chevron-double-left',
            self::LLCL => 'heroicon-o-chevron-double-down',
            self::FLCL => 'heroicon-o-chevron-double-right',
            self::FFCL => 'heroicon-o-chevron-double-up',
            self::CYCFS => 'heroicon-o-chevron-left',
            self::CYCY => 'heroicon-o-chevron-down',
            self::CFSCY => 'heroicon-o-chevron-right',
            self::CFSCFS => 'heroicon-o-chevron-up',
        };
    }
}