<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum BackOfficeTypes: string implements HasLabel, HasColor, HasIcon
{
    case DEPOT = 'depot';
    case OPERATOR = 'operator';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::DEPOT => 'Depot',
            self::OPERATOR => 'Vessel Operator',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::DEPOT => 'info',
            self::OPERATOR => 'secondary',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::DEPOT => 'heroicon-o-building-storefront',
            self::OPERATOR => 'heroicon-o-home-modern',
        };
    }
}