<?php

namespace App\Enums;

use Filament\Support\Contracts\HasIcon;
use Filament\Support\Contracts\HasColor;
use Filament\Support\Contracts\HasLabel;

enum BLTypes: string implements HasLabel, HasColor, HasIcon
{
    case SURRENDER = 'surrender';
    case ORIGINAL = 'original';
    case SHIPPED = 'shipped';
    case DRAFT = 'draft';

	public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    // public static function forSelect(): array 
    // {
    //     return array_combine(
    //         array_column(self::cases(), 'value'),
    //         array_column(self::cases(), 'name')
    //     );
    // }
    
    public function getLabel(): ?string
    {
        return match ($this) {
            self::SURRENDER => 'Surrender',
            self::ORIGINAL => 'Original',
            self::SHIPPED => 'Shipped',
            self::DRAFT => 'Draft',
        };
    }

    public function getColor(): string | array | null
    {
        return match ($this) {
            self::SURRENDER => 'agent',
            self::ORIGINAL => 'success',
            self::SHIPPED => 'warning',
            self::DRAFT => 'gray',
        };
    }

    public function getIcon(): ?string
    {
        return match ($this) {
            self::SURRENDER => 'heroicon-o-document-text',
            self::ORIGINAL => 'heroicon-o-check',
            self::SHIPPED => 'heroicon-o-briefcase',
            self::DRAFT => 'heroicon-o-pencil',
        };
    }
}