<?php

namespace App\Classes;

use App\Models\Office;
use Illuminate\Support\Facades\Auth;

final class TzDateTime
{
    static public function getOfficeTimeZone($multiple = false, $office_id = null) : string|array|\stdClass {
        $offices = (!empty($office_id))?Office::where('id', $office_id)->with('country')->get():Auth::user()->office()->get();

        $user_office_timezones = [];
        foreach ($offices as $office) {
            $user_office_timezones[] = collect(json_decode($office->country->timezones))->first();
        }

        return $multiple?$user_office_timezones:collect($user_office_timezones)->first();
    }
}
